/*--------------------------------------------------------------------------*\

    FILE....: TOGBIT.CPP
    TYPE....: C++ Program
    AUTHOR..: David Rowe
    DATE....: 28/3/01

    Test program used for debugging Voicetronix VPB4 & VPB8L ISA cards.  This 
    program writes an alternating pattern to a specifc memory address.

    Compile: gcc togbit.cpp -o togbit -Wall -g ../linux/libvpb.a -pthread
    Run....: ./togbit BASE ADDR' ( e.g. './togbit 0x300 0x400')

    Use ctrl-C to end.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "../src/vpbapi.h"
#include "../src/hip.h"

int main(int argc, char *argv[]) {
	unsigned short    wr_val, rd_val;
	int               wr_addr1, wr_addr2, rd_addr, value;
	int               base;

	if (argc != 5) {
		printf("usage: togbit BASE wr_addr1 wr_addr2 value\n");
		printf("e.g. 'togbit 0x310 0x0 0x400 0xffff'\n");
		exit(0);
	}

	// init
	sscanf(argv[1], "%x", &base);
	sscanf(argv[2], "%x", &wr_addr1);
	sscanf(argv[3], "%x", &wr_addr2);
	sscanf(argv[4], "%x", &value);
 
	Hip h(0);  // use kernel mode driver (must be installed)

	// Place DSP in reset
	h.InitVpb(base);
	h.DspReset(0);

	//wr_addr1 = 0x40f;
	//wr_addr2 = 0x40f;
	rd_addr = wr_addr1;
	//wr_val = 0x0000;
	//h.WriteDspSram(0, rd_addr, 1, &wr_val);
	
	while(1) {

		wr_val = 0x0;
		h.WriteDspSram(0, wr_addr1, 1, &wr_val);
		h.ReadDspSram(0, rd_addr, 1, &rd_val);
		printf("[0x%04x]write val: 0x%04x  [0x%04x]read val: 0x%04x\n"
		       ,wr_addr1, wr_val, rd_addr, rd_val);

		wr_val = 0xffff;
		h.WriteDspSram(0, wr_addr2, 1, &wr_val);
		h.ReadDspSram(0, rd_addr, 1, &rd_val);
		printf("[0x%04x]write val: 0x%04x  [0x%04x]read val: 0x%04x\n"
		       ,wr_addr2, wr_val, rd_addr, rd_val);
	}

	return 0;
}





